file_list=$1
# This only works if each file that's found in the working directory's
# tree has a unique basename.
# 
# The parsing is for output as found here:
# https://redmine.replicant.us/projects/replicant/wiki/GT-I9300EFSContent
# Some ls programs format the date differently.
#
# The directories mode bits, owner and group will not be changed.
(OLD_IFS="$IFS"; \
 IFS='
'; \
 for line in $(IFS=$OLD_IFS; \
	    cat $file_list \
		| grep '^[-d]' \
		| grep -v ' \.\.$' \
		| grep -v ' \.$') ; \
 do (IFS=$OLD_IFS; \
     file_name=$(echo $line | cut -d ' ' -f 9); \
     file=$(find . -name "$file_name"); \
     owner=$(echo $line | cut -d ' ' -f 3); \
     group=$(echo $line | cut -d ' ' -f 4); \
     user_bits=$(echo $line | cut -c 2-4 | tr -d '-'); \
     group_bits=$(echo $line | cut -c 5-7 | tr -d '-'); \
     others_bits=$(echo $line | cut -c 8-10 | tr -d '-'); \
     if [ -z "$file" ]; \
     then echo "$file_name not found."; \
	  echo "The line was:"; \
	  echo "$line"; \
     else \
	 chmod  u=$user_bits,g=$group_bits,o=$others_bits $file; \
	 chown  $owner $file; \
	 chgrp  $group $file; \
     fi; \
     ); \
 done; \
 IFS=$OLD_IFS)
