#
#	     THIS IS FREE SOFTWARE 
#
# Copyright 2016 Filippo "Fil" Bergamo
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


ifacename=wlan0
scanfile=/data/misc/wifi/scanres.txt
socketfile=/data/misc/wifi/sockets
pidfile=/data/misc/wifi/pidfile
scriptWriteConf=/data/misc/wifi/write_config.sh
scriptStartWPA=/data/misc/wifi/startwpa.sh
scriptConnect=/data/misc/wifi/connect.sh
scriptDiscon=/data/misc/wifi/disconnect.sh

bash "$scriptDiscon"
if [ $? -ne 0 ]; then
	exit
fi
sleep 1s

bash $scriptStartWPA
if [ $? -ne 0 ]; then
	exit
fi
sleep 1s


# scan for networks
echo -n "Scanning for networks... "
wpa_cli -p$socketfile -P$pidfile -i$ifacename scan
if [ $? -ne 0 ]; then
	exit
fi
sleep 2s

# store the scan results on file
if [ -e $scanfile ]; then
	rm $scanfile
fi
sleep 1s

echo -n "Retrieving network list... "
wpa_cli -p$socketfile -P$pidfile -i$ifacename scan_results > $scanfile
if [ $? -ne 0 ]; then
	exit
fi
sleep 1s

# read the results in a variable:
networks=$(grep -v --invert-match '^bssid' $scanfile)

# count the number of networks:
netnum=$(echo "$networks" | wc -l)

# check if there is at least one network in the list
if [ "$netnum" == "" ] || [ "$netnum" -lt 1 ]; then
	echo "No networks found!"
	exit
fi


# store each network in array
idx=0
declare -a arrnets
printf %s "$networks" | while IFS= read -r line
do
	arrnets[$idx]="$line"
	idx=$(($idx+1))
done

if [ $? -ne 0 ]; then
	exit
fi

echo ""
echo "Please input the number of the network you want to connect to:"
echo -e "\t # |  SSID"
echo -e "\t---|------------------"

idx=1
declare -a AR
while IFS= read -r line
do
	# split the line into the different properties:
	read -r -a SUBAR <<< "$line"
	AR[$idx]=${SUBAR[4]} #the SSID is the 4th field
	echo -e "\t"$idx") | "${SUBAR[4]}

	idx=$(($idx+1))
done <<< "$networks"

# read user's choice
read selnet

if ! [[ "$selnet" =~ ^[0-9]+$ ]]; then
	echo "Invalid input!"
	exit
fi

if [ "$selnet" -le 0 ] || [ "$selnet" -gt "$netnum" ]; then
	echo "Invalid number!"
	exit
fi

selectedSSID=${AR[$selnet]}

echo "Enter a password for "$selectedSSID
read password

bash "$scriptWriteConf" $selectedSSID $password 
if [ $? -ne 0 ]; then
	exit
fi

sleep 1s

echo "Do you want to connect to "$selectedSSID" now? [y/n] "
read answer

if [ $answer = "y" ] || [ $answer = "Y" ]; then
	source $scriptConnect
fi

