import sys
import re
import argparse

args = None
gitver = dict()

def warn(msg):
    sys.stderr.write('{0}: warning: {1}\n'.format(sys.argv[0], msg))

def load_gitver():
    with open(args.gitver, 'r') as f:
        for line in f:
            a = line.rstrip('\n').split(' ')
            if len(a) != 3 or a[1] != 'commit':
                sys.stderr.write('invalid git_versions.txt line: '+line)
            gitver[a[0]] = a[2]

def rewrite_manifest(out):
    projectexp = re.compile('\s*<project .*/>\s*')
    pathexp = re.compile(' path="([^"]*)"')
    with open(args.manifest, 'r') as f:
        for line in f:
            if projectexp.match(line):
                pathm = pathexp.search(line)
                if pathm:
                    path = pathm.group(1)
                    if path in gitver:
                        line = re.sub(' revision="', ' upstream="', line)
                        line = re.sub('/>\s*$',
                                      'revision="'+gitver[path]+'" />\n',
                                      line)
                        del gitver[path]
                    else:
                        warn('unknown project {0} in manifest'.format(
                                repr(path)))
            out.write(line)
    if 'build' in gitver:
        del gitver['build']     # ok if missing
    if len(gitver) > 0:
        warn('extra projects {0} in gitver'.format(
                repr(gitver.keys())))

def main():
    global args
    parser = argparse.ArgumentParser()
    parser.add_argument('manifest', type=str,
                        help='XML manifest file name')
    parser.add_argument('gitver', type=str,
                        help='Replicant git_versions.txt file name')
    args = parser.parse_args()
    load_gitver()
    rewrite_manifest(sys.stdout)

if __name__ == '__main__':
    main()
