export REPLICANT_BASE=/YOUR/BASE/DIR

export PREFIX=${REPLICANT_BASE}/out/target/product/i9305/system
export SYSROOT=${REPLICANT_BASE}/prebuilts/ndk/current/platforms/android-21/arch-arm
export TOOLCHAIN_PATH=${REPLICANT_BASE}/toolchain/gcc/arm/arm-linux-androideabi/install
export TOOLCHAIN_PREFIX=arm-linux-androideabi
export CROSS_PREFIX=${TOOLCHAIN_PATH}/bin/${TOOLCHAIN_PREFIX}

export PKG_CONFIG_PATH=${PREFIX}/lib/pkgconfig
export BUILD_SYSTEM=x86_64-linux-gnu

# build flags
export CFLAGS="--sysroot=${SYSROOT} -I${SYSROOT}/usr/include -I${PREFIX}/include -fPIE -DANDROID -Wno-multichar"
export CXXFLAGS=${CFLAGS}
export CPPFLAGS="--sysroot=${SYSROOT} -I${SYSROOT}/usr/include -I${TOOLCHAIN_PATH}/include -DANDROID -DNO_XMALLOC -mandroid"
export LDFLAGS="-Wl,-rpath-link=-I${SYSROOT}/usr/lib -L${PREFIX}/lib -L${SYSROOT}/usr/lib -L${TOOLCHAIN_PATH}/lib -pie"
export LIBS="-lc"

# Non-exhaustive lists of compiler + binutils
export AR=${CROSS_PREFIX}-ar
export AS=${CROSS_PREFIX}-as
export LD=${CROSS_PREFIX}-ld
export NM=${CROSS_PREFIX}-nm
export CC=${CROSS_PREFIX}-gcc
export CXX=${CROSS_PREFIX}-g++
export CPP=${CROSS_PREFIX}-cpp
export CXXCPP=${CROSS_PREFIX}-cpp
export STRIP=${CROSS_PREFIX}-strip
export RANLIB=${CROSS_PREFIX}-ranlib
export STRINGS=${CROSS_PREFIX}-strings
